/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.protocols.dlg;

import com.eloquence.services.protocols.dlg.Dlg;
import com.eloquence.services.protocols.dlg.Dmdrv;
import com.eloquence.services.tools.HexTool;
import com.eloquence.services.tools.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

final class Dmdrv_V1
extends Dmdrv {
    private byte[] bf = new byte[8280];
    private static final int CALL_SIZE = 88;
    private static final int ARGS_SIZE = 8192;
    private static final int SEND_MAX = 8196;
    private boolean exec = true;
    private int pendingAsyncStatus = 0;
    private int bf_used;
    private int bf_off;
    static char[] hp_roman8_ISO_8859_1 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00c0', '\u00c2', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u00b4', '\u00a9', '\u00f7', '\u00a8', '\u00ac', '\u00d9', '\u00db', '\u00b3', '\u00af', '\u00dd', '\u00fd', '\u00b0', '\u00c7', '\u00e7', '\u00d1', '\u00f1', '\u00a1', '\u00bf', '\u00a4', '\u00a3', '\u00a5', '\u00a7', '\u00b2', '\u00a2', '\u00e2', '\u00ea', '\u00f4', '\u00fb', '\u00e1', '\u00e9', '\u00f3', '\u00fa', '\u00e0', '\u00e8', '\u00f2', '\u00f9', '\u00e4', '\u00eb', '\u00f6', '\u00fc', '\u00c5', '\u00ee', '\u00d8', '\u00c6', '\u00e5', '\u00ed', '\u00f8', '\u00e6', '\u00c4', '\u00ec', '\u00d6', '\u00dc', '\u00c9', '\u00ef', '\u00df', '\u00d4', '\u00c1', '\u00c3', '\u00e3', '\u00d0', '\u00f0', '\u00cd', '\u00cc', '\u00d3', '\u00d2', '\u00d5', '\u00f5', '\u00d7', '\u00ad', '\u00da', '\u00b9', '\u00ff', '\u00de', '\u00fe', '\u00b7', '\u00b5', '\u00b6', '\u00be', '\u00a6', '\u00bc', '\u00bd', '\u00aa', '\u00ba', '\u00ab', '\u00b8', '\u00bb', '\u00b1', '\u00ae'};
    static char[] ISO_8859_1_hp_roman8 = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0080', '\u0081', '\u0082', '\u0083', '\u0084', '\u0085', '\u0086', '\u0087', '\u0088', '\u0089', '\u008a', '\u008b', '\u008c', '\u008d', '\u008e', '\u008f', '\u0090', '\u0091', '\u0092', '\u0093', '\u0094', '\u0095', '\u0096', '\u0097', '\u0098', '\u0099', '\u009a', '\u009b', '\u009c', '\u009d', '\u009e', '\u009f', '\u00a0', '\u00b8', '\u00bf', '\u00bb', '\u00ba', '\u00bc', '\u00f6', '\u00bd', '\u00ab', '\u00a9', '\u00f9', '\u00fb', '\u00ac', '\u00ec', '\u00ff', '\u00b0', '\u00b3', '\u00fe', '\u00be', '\u00af', '\u00a8', '\u00f3', '\u00f4', '\u00f2', '\u00fc', '\u00ee', '\u00fa', '\u00fd', '\u00f7', '\u00f8', '\u00f5', '\u00b9', '\u00a1', '\u00e0', '\u00a2', '\u00e1', '\u00d8', '\u00d0', '\u00d3', '\u00b4', '\u00a3', '\u00dc', '\u00a4', '\u00a5', '\u00e6', '\u00e5', '\u00a6', '\u00a7', '\u00e3', '\u00b6', '\u00e8', '\u00e7', '\u00df', '\u00e9', '\u00da', '\u00eb', '\u00d2', '\u00ad', '\u00ed', '\u00ae', '\u00db', '\u00b1', '\u00f0', '\u00de', '\u00c8', '\u00c4', '\u00c0', '\u00e2', '\u00cc', '\u00d4', '\u00d7', '\u00b5', '\u00c9', '\u00c5', '\u00c1', '\u00cd', '\u00d9', '\u00d5', '\u00d1', '\u00dd', '\u00e4', '\u00b7', '\u00ca', '\u00c6', '\u00c2', '\u00ea', '\u00ce', '\u00aa', '\u00d6', '\u00cb', '\u00c7', '\u00c3', '\u00cf', '\u00b2', '\u00f1', '\u00ef'};

    Dmdrv_V1() {
    }

    void dispose() {
        super.dispose();
        this.bf = null;
    }

    boolean exec(Dlg dlg) throws IOException, InterruptedException {
        OutputStream outputStream;
        if (!this.exec) {
            throw new RuntimeException("Duplicate invocation of DLG protocol handler");
        }
        InputStream inputStream = dlg.sck.getInputStream();
        if (!this.startProtocol(dlg, inputStream, outputStream = dlg.sck.getOutputStream())) {
            this.exec = false;
            return false;
        }
        while (this.exec) {
            if (!this.rqRecv(inputStream)) {
                dlg.connectionReset(null);
                dlg.stopSession();
                this.exec = false;
                return false;
            }
            int n = this.decodeInt();
            if (n != 0) {
                System.err.println("DLG client error: " + n);
                this.exec = false;
                return false;
            }
            Dlg.Rq rq = this.rq(this.decodeInt());
            if (rq == null || !rq.exec(dlg)) {
                if (rq != null) {
                    rq.dispose();
                }
                this.protocolFailed(outputStream);
                this.exec = false;
                return false;
            }
            rq.dispose();
            this.rsSend(outputStream);
            if (dlg.drv == this) continue;
            this.dispose();
            this.exec = false;
            return true;
        }
        return false;
    }

    private void protocolFailed(OutputStream outputStream) {
        try {
            this.encodeInit();
            this.encodeInt(-1);
            this.rsSend(outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void stopReceived() {
        this.exec = false;
    }

    void sendNopResponse(Dlg dlg) {
        try {
            this.encodeInit();
            this.encodeInt(0);
            this.encodeInt(18);
            this.rsSend(dlg.sck.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    boolean decode(Dlg.Rq.STOP sTOP) {
        return true;
    }

    boolean decode(Dlg.Rq.LOAD lOAD) {
        this.decodeSkipString();
        return true;
    }

    boolean decode(Dlg.Rq.NEW nEW) {
        nEW.path = this.decodeString();
        nEW.classnm = this.decodeString();
        return true;
    }

    boolean decode(Dlg.Rq.DEL dEL) {
        dEL.path = this.decodeString();
        return true;
    }

    private int attr(String string) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 > (n = string.lastIndexOf(33))) {
            return n2;
        }
        if (n > n2) {
            return n;
        }
        return -1;
    }

    private String index(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 0 && string.charAt(n2 - 1) == ']' && (n = string.indexOf(91)) != -1) {
            return string.substring(n + 1, n2 - 1);
        }
        return null;
    }

    boolean decode(Dlg.Rq.SET sET) {
        sET.path = this.decodeString();
        int n = this.attr(sET.path);
        if (n >= 0) {
            sET.attr = sET.path.substring(n + 1).toLowerCase();
            sET.path = n > 0 ? sET.path.substring(0, n) : null;
        } else {
            sET.attr = sET.path.toLowerCase();
            sET.path = null;
        }
        sET.index = this.index(sET.attr);
        if (sET.index != null) {
            sET.attr = sET.attr.substring(0, sET.attr.length() - sET.index.length() - 2);
        }
        sET.v_type = this.decodeInt();
        if (sET.v_type == 2 && sET.attr.equals("print") && sET.path != null && sET.path.equalsIgnoreCase("application")) {
            sET.v_type = 3;
        } else if (sET.v_type == 3) {
            throw new RuntimeException("DLG client unexpected BINARY value type");
        }
        switch (sET.v_type) {
            case 0: {
                sET.v_iv = 0;
                sET.v_sv = null;
                sET.v_bv = null;
                sET.v_bv_len = 0;
                sET.v_bv_off = 0;
                break;
            }
            case 1: {
                sET.v_iv = this.decodeInt();
                sET.v_sv = null;
                sET.v_bv = null;
                sET.v_bv_len = 0;
                sET.v_bv_off = 0;
                break;
            }
            case 2: {
                sET.v_sv = this.decodeString();
                sET.v_iv = 0;
                sET.v_bv = null;
                sET.v_bv_len = 0;
                sET.v_bv_off = 0;
                break;
            }
            case 3: {
                sET.v_bv_off = this.decodeInt() + 88 - 1;
                if (sET.v_bv_off < 88 || sET.v_bv_off >= this.bf_used) {
                    throw new RuntimeException("Invalid DLG buffer binary offset: " + sET.v_bv_off + ", min: " + 88 + ", max: " + (this.bf_used - 1));
                }
                sET.v_bv = this.bf;
                sET.v_bv_len = this.bf_used - sET.v_bv_off;
                sET.v_iv = 0;
                sET.v_sv = null;
                break;
            }
            default: {
                throw new RuntimeException("DLG client invalid value type: " + sET.v_type);
            }
        }
        return true;
    }

    boolean decode(Dlg.Rq.GET gET) {
        gET.path = this.decodeString();
        int n = this.attr(gET.path);
        if (n >= 0) {
            gET.attr = gET.path.substring(n + 1).toLowerCase();
            gET.path = n > 0 ? gET.path.substring(0, n) : null;
        } else {
            gET.attr = gET.path.toLowerCase();
            gET.path = null;
        }
        gET.index = this.index(gET.attr);
        if (gET.index != null) {
            gET.attr = gET.attr.substring(0, gET.attr.length() - gET.index.length() - 2);
        }
        return true;
    }

    boolean decode(Dlg.Rq.DO dO) {
        this.pendingAsyncStatus = 0;
        dO.path = this.decodeString();
        return true;
    }

    boolean decode(Dlg.Rq.DRAW dRAW) {
        dRAW.path = this.decodeString();
        return true;
    }

    boolean decode(Dlg.Rq.POPUP pOPUP) {
        this.pendingAsyncStatus = 0;
        this.decodeSkipInt();
        this.decodeSkipInt();
        this.decodeSkipString();
        pOPUP.x = this.decodeInt();
        pOPUP.y = this.decodeInt();
        pOPUP.title = this.decodeString();
        pOPUP.text = this.decodeString().split("\n");
        int n = this.decodeInt();
        if (n < 0 || n > 5) {
            throw new RuntimeException("DLG client unexpected POPUP BOX button count: " + n);
        }
        int n2 = 0;
        if (n > 0) {
            pOPUP.btn = new String[n];
            while (n2 < n) {
                pOPUP.btn[n2++] = this.decodeString();
            }
        } else {
            pOPUP.btn = new String[0];
        }
        while (n2++ < 5) {
            this.decodeSkipInt();
        }
        pOPUP.def_btn = this.decodeInt();
        return true;
    }

    boolean decode(Dlg.Rq.HELP hELP) {
        hELP.tag = this.decodeString();
        return true;
    }

    boolean decode(Dlg.Rq.ASYNC aSYNC) {
        aSYNC.mode = this.decodeInt();
        return true;
    }

    boolean encode(Dlg.Rs.STATUS sTATUS) {
        this.encodeInit();
        if (sTATUS.isAsync) {
            if (sTATUS.status != 0 && this.pendingAsyncStatus == 0) {
                this.pendingAsyncStatus = sTATUS.status;
            }
            sTATUS.dispose();
            return true;
        }
        this.encodeInt(0);
        this.encodeInt(12);
        this.encodeInt(sTATUS.status);
        sTATUS.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.LOAD lOAD) {
        this.encodeInit();
        this.encodeInt(0);
        this.encodeInt(8);
        this.encodeInt(lOAD.status);
        lOAD.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.GET gET) {
        this.encodeInit();
        this.encodeInt(0);
        this.encodeInt(7);
        if (gET.status != 0) {
            gET.v_type = 0;
        }
        switch (gET.v_type) {
            case 1: {
                this.encodeInt(gET.status);
                this.encodeInt(gET.v_type);
                this.encodeInt(gET.v_iv);
                break;
            }
            case 2: {
                if (gET.v_sv.length() > 8103) {
                    this.encodeInt(34);
                    this.encodeInt(0);
                    break;
                }
                this.encodeInt(gET.status);
                this.encodeInt(gET.v_type);
                this.encodeString(gET.v_sv);
                break;
            }
            case 3: {
                if (gET.v_bv_len > 8104) {
                    this.encodeInt(34);
                    this.encodeInt(0);
                    break;
                }
                int n = this.bf_used + 88 + 4;
                if (n + gET.v_bv_len > 8196) {
                    throw new RuntimeException("DLG buffer offset exceeded: " + (n + gET.v_bv_len) + ", max: " + 8196);
                }
                this.encodeInt(gET.status);
                this.encodeInt(gET.v_type);
                this.encodeInt(this.bf_used + 1);
                this.bf_used += gET.v_bv_len;
                System.arraycopy(gET.v_bv, 0, this.bf, n, gET.v_bv_len);
                break;
            }
            default: {
                this.encodeInt(gET.status);
                this.encodeInt(0);
            }
        }
        gET.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.DO dO) {
        this.encodeInit();
        this.encodeInt(0);
        this.encodeInt(10);
        this.encodeInt(dO.status);
        this.encodeInt(dO.rule);
        this.encodeString(dO.path);
        dO.dispose();
        return true;
    }

    boolean encode(Dlg.Rs.POPUP pOPUP) {
        this.rs_DO.status = pOPUP.status;
        this.rs_DO.rule = pOPUP.btn;
        this.rs_DO.path = "POPUP_BOX";
        pOPUP.dispose();
        return this.encode(this.rs_DO);
    }

    boolean encode(Dlg.Rs.ASYNC aSYNC) {
        this.encodeInit();
        this.encodeInt(0);
        this.encodeInt(16);
        this.encodeInt(aSYNC.mode);
        aSYNC.dispose();
        return true;
    }

    private boolean rqRecv(InputStream inputStream) throws IOException {
        if (!this.recv(inputStream, 4)) {
            return false;
        }
        this.bf_used = 4;
        this.bf_used = this.decodeInt() - 4;
        if (this.bf_used < 8 || this.bf_used > this.bf.length) {
            throw new RuntimeException("DLG client request size invalid: " + this.bf_used);
        }
        if (!this.recv(inputStream, this.bf_used)) {
            return false;
        }
        int n = this.decodeInt();
        if (n != this.bf_used) {
            throw new RuntimeException("DLG client request size invalid: " + n + ", expected: " + this.bf_used);
        }
        return true;
    }

    private boolean recv(InputStream inputStream, int n) throws IOException {
        if (n > this.bf.length) {
            throw new RuntimeException("DLG buffer size exceeded: " + n);
        }
        int n2 = 0;
        while (n > 0) {
            int n3 = inputStream.read(this.bf, n2, n);
            if (n3 == -1) {
                return false;
            }
            n2 += n3;
            n -= n3;
        }
        this.bf_off = 0;
        return true;
    }

    private void rsSend(OutputStream outputStream) throws IOException {
        if (this.bf_off > 0) {
            int n;
            if (this.pendingAsyncStatus != 0) {
                byte[] byArray = this.bf;
                this.bf = new byte[20];
                this.encodeInt(20, 0);
                this.encodeInt(16, 4);
                this.encodeInt(0, 8);
                this.encodeInt(12, 12);
                this.encodeInt(this.pendingAsyncStatus, 16);
                outputStream.write(this.bf, 0, this.bf.length);
                this.bf = byArray;
                this.pendingAsyncStatus = 0;
            }
            if (this.bf_used == 0) {
                n = this.bf_off - 4;
            } else {
                n = this.bf_used + 88;
                if (this.bf_off < 92) {
                    Arrays.fill(this.bf, this.bf_off, 92, (byte)0);
                }
            }
            this.encodeInt(n + 4, 0);
            this.encodeInt(n, 4);
            outputStream.write(this.bf, 0, n + 4);
            outputStream.flush();
        }
    }

    private boolean startProtocol(Dlg dlg, InputStream inputStream, OutputStream outputStream) throws IOException {
        if (!this.recv(inputStream, 4)) {
            System.err.println(dlg.getName() + " Failed to establish DLG protocol");
            return false;
        }
        this.bf_used = 4;
        this.bf_used = this.decodeInt();
        if (this.bf_used < 8 || this.bf_used > this.bf.length) {
            System.err.println(dlg.getName() + " Initial DLG client request size invalid: " + this.bf_used);
            return false;
        }
        if (!this.recv(inputStream, this.bf_used)) {
            return false;
        }
        if (this.bf[0] != 69 || this.bf[1] != 81 || this.bf[2] != 46 || this.bf[3] != 68 || this.bf[4] != 76 || this.bf[5] != 71 || this.bf[6] != 1 || this.bf[7] != 0) {
            if (!dlg.isRdlg || !this.eloqsdDecodeResponse(dlg)) {
                System.err.println(dlg.getName() + " Initial DLG client request not recognized");
            }
            return false;
        }
        int n = 8;
        while (n-- > 0) {
            this.bf[n + 4] = this.bf[n];
        }
        this.encodeInt(8, 0);
        outputStream.write(this.bf, 0, 12);
        outputStream.flush();
        return true;
    }

    private int decodeInt() {
        int n = this.bf_off;
        this.bf_off += 4;
        if (this.bf_off > this.bf_used || this.bf_off > 88) {
            throw new RuntimeException("DLG buffer offset exceeded: " + this.bf_off + ", max: " + (this.bf_used < 88 ? this.bf_used : 88));
        }
        return (this.bf[n] & 0xFF) << 24 | (this.bf[n + 1] & 0xFF) << 16 | (this.bf[n + 2] & 0xFF) << 8 | this.bf[n + 3] & 0xFF;
    }

    private void decodeSkipInt() {
        this.bf_off += 4;
        if (this.bf_off > this.bf_used || this.bf_off > 88) {
            throw new RuntimeException("DLG buffer offset exceeded: " + this.bf_off + ", max: " + (this.bf_used < 88 ? this.bf_used : 88));
        }
    }

    private String decodeString() {
        int n = this.decodeInt() + 88 - 1;
        if (n < 88 || n >= this.bf_used) {
            throw new RuntimeException("Invalid DLG buffer string offset: " + n + ", min: " + 88 + ", max: " + (this.bf_used - 1));
        }
        int n2 = 0;
        int n3 = n;
        while (true) {
            if (n3 >= this.bf_used) {
                throw new RuntimeException("DLG buffer string not terminated, index: " + (n3 - n) + ", offset: " + n3 + ", max: " + (this.bf_used - 1));
            }
            if (this.bf[n3++] == 0) break;
            ++n2;
        }
        if (n2 == 0) {
            return "";
        }
        char[] cArray = new char[n2];
        block6: for (int i = 0; i < n2; ++i) {
            char c = (char)(this.bf[n++] & 0xFF);
            switch (c) {
                case '\u00ba': {
                    cArray[i] = 8364;
                    continue block6;
                }
                case '\u00eb': {
                    cArray[i] = 352;
                    continue block6;
                }
                case '\u00ec': {
                    cArray[i] = 353;
                    continue block6;
                }
                default: {
                    cArray[i] = hp_roman8_ISO_8859_1[c];
                }
            }
        }
        return new String(cArray);
    }

    private void decodeSkipString() {
        int n = this.decodeInt() + 88 - 1;
        if (n < 88 || n >= this.bf_used) {
            throw new RuntimeException("Invalid DLG buffer string offset: " + n + ", min: " + 88 + ", max: " + (this.bf_used - 1));
        }
        int n2 = n;
        do {
            if (n2 < this.bf_used) continue;
            throw new RuntimeException("DLG buffer string not terminated, index: " + (n2 - n) + ", offset: " + n2 + ", max: " + (this.bf_used - 1));
        } while (this.bf[n2++] != 0);
    }

    private void encodeInit() {
        this.bf_used = 0;
        this.bf_off = 0;
    }

    private void encodeInt(int n) {
        if (this.bf_off == 0) {
            this.bf_off = 8;
        }
        int n2 = this.bf_off;
        this.bf_off += 4;
        if (this.bf_off > 88) {
            throw new RuntimeException("DLG buffer offset exceeded: " + this.bf_off + ", max: " + 88);
        }
        this.encodeInt(n, n2);
    }

    private void encodeInt(int n, int n2) {
        this.bf[n2++] = (byte)(n >> 24 & 0xFF);
        this.bf[n2++] = (byte)(n >> 16 & 0xFF);
        this.bf[n2++] = (byte)(n >> 8 & 0xFF);
        this.bf[n2++] = (byte)(n & 0xFF);
    }

    private void encodeString(String string) {
        int n = this.bf_used + 88 + 4;
        int n2 = string.length();
        if (n + n2 + 1 > 8196) {
            throw new RuntimeException("DLG buffer offset exceeded: " + (n + n2 + 1) + ", max: " + 8196);
        }
        this.encodeInt(this.bf_used + 1);
        this.bf_used += n2 + 1;
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            switch (c) {
                case '\u0110': {
                    this.bf[n] = -29;
                    break;
                }
                case '\u0111': {
                    this.bf[n] = -28;
                    break;
                }
                case '\u0160': {
                    this.bf[n] = -21;
                    break;
                }
                case '\u0161': {
                    this.bf[n] = -20;
                    break;
                }
                case '\u0178': {
                    this.bf[n] = -18;
                    break;
                }
                case '\u0192': {
                    this.bf[n] = -66;
                    break;
                }
                case '\u02c6': {
                    this.bf[n] = -86;
                    break;
                }
                case '\u02c9': {
                    this.bf[n] = -80;
                    break;
                }
                case '\u02da': {
                    this.bf[n] = -77;
                    break;
                }
                case '\u02dc': 
                case '\u0303': {
                    this.bf[n] = -84;
                    break;
                }
                case '\u0300': {
                    this.bf[n] = -87;
                    break;
                }
                case '\u0301': {
                    this.bf[n] = -88;
                    break;
                }
                case '\u03bc': {
                    this.bf[n] = -13;
                    break;
                }
                case '\u2013': {
                    this.bf[n] = 45;
                    break;
                }
                case '\u2014': 
                case '\u2015': {
                    this.bf[n] = -10;
                    break;
                }
                case '\u2017': {
                    this.bf[n] = 95;
                    break;
                }
                case '\u2018': 
                case '\u2019': 
                case '\u201a': 
                case '\u201b': 
                case '\u2032': {
                    this.bf[n] = 39;
                    break;
                }
                case '\u201c': 
                case '\u201d': 
                case '\u201e': 
                case '\u2033': {
                    this.bf[n] = 34;
                    break;
                }
                case '\u2022': 
                case '\u2219': {
                    this.bf[n] = -14;
                    break;
                }
                case '\u2039': {
                    this.bf[n] = 60;
                    break;
                }
                case '\u203a': {
                    this.bf[n] = 62;
                    break;
                }
                case '\u203e': {
                    this.bf[n] = -80;
                    break;
                }
                case '\u2044': 
                case '\u2215': {
                    this.bf[n] = 47;
                    break;
                }
                case '\u20ac': {
                    this.bf[n] = -70;
                    break;
                }
                default: {
                    if (c >= '\u0000' && c < '\u0100') {
                        this.bf[n] = (byte)ISO_8859_1_hp_roman8[c];
                        break;
                    }
                    this.bf[n] = 63;
                    System.err.println("DLG character conversion failed: \\u" + HexTool.int2hexString(c, 2));
                }
            }
            ++n3;
            ++n;
        }
        this.bf[n] = 0;
    }

    private boolean eloqsdDecodeResponse(Dlg dlg) {
        String string;
        int n = this.eloqsdDecodeInt16();
        if ((n == 1 || n == 2) && (string = this.eloqsdDecodeString()) != null) {
            dlg.connectionReset(Strings.get("message.text.failedtostart") + string);
            return true;
        }
        return false;
    }

    private int eloqsdDecodeInt16() {
        int n = this.bf_off;
        this.bf_off += 2;
        if (this.bf_off > this.bf_used) {
            return -1;
        }
        return (this.bf[n] & 0xFF) << 8 | this.bf[n + 1] & 0xFF;
    }

    private String eloqsdDecodeString() {
        int n = this.eloqsdDecodeInt16();
        int n2 = this.bf_off;
        if (n >= 1) {
            this.bf_off += n;
            if (this.bf_off <= this.bf_used && this.bf[this.bf_off + n - 1] == 0) {
                return new String(this.bf, n2, n - 1);
            }
        }
        return null;
    }

    static String getDriverProperties() {
        return Dlg.getDriverProperties("hp-roman8", false);
    }
}

