/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.protocols.eloqsd;

import com.eloquence.services.protocols.eloqsd.Conversions;
import com.eloquence.services.protocols.eloqsd.eloqsd;
import com.eloquence.services.tools.Strings;
import java.nio.charset.Charset;

abstract class ProtocolAction {
    protected final Charset cs_ascii = Charset.forName("UTF-8");
    protected final Charset cs_latin1 = Charset.forName("ISO-8859-1");
    public static final int REPLY_STAT_OK = 0;
    public static final int REPLY_STAT_MSG = 1;
    public static final int REPLY_STAT_ERR = 2;
    public static final int MSG_TYPE_OK = 0;
    public static final int MSG_TYPE_ERROR = 1;
    public static final int MSG_TYPE_WARNING = 2;
    protected eloqsd conn = null;
    protected String errorMessage = "";
    protected String warningMessage = "";
    private int messageType = 0;

    abstract void sendRequest();

    abstract byte[] getNetworkPresentation();

    abstract void receiveRequest();

    abstract void setFromNetworkPresentation(byte[] var1);

    protected boolean handleStatus(byte[] byArray) {
        if (byArray != null && byArray.length != 0) {
            int n = Conversions.createIntFromInt16(byArray, 0);
            switch (n) {
                case 0: {
                    return true;
                }
                case 1: {
                    this.messageType = 2;
                    this.warningMessage = Conversions.createString(byArray, 2, this.cs_latin1);
                    this.conn.setContinue(false);
                    return false;
                }
                case 2: {
                    this.messageType = 1;
                    this.errorMessage = Conversions.createString(byArray, 2, this.cs_latin1);
                    this.conn.setContinue(false);
                    return false;
                }
            }
            return false;
        }
        this.messageType = 1;
        this.errorMessage = Strings.get("message.text.failedtostart") + Strings.get("message.text.connectionreset");
        this.conn.setContinue(false);
        return false;
    }

    int getReturnCode() {
        return this.messageType;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    String getWarningMessage() {
        return this.warningMessage;
    }

    public ProtocolAction(eloqsd eloqsd2) {
        this.conn = eloqsd2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.conn = null;
    }
}

