/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.sessions;

import com.eloquence.services.tools.Strings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class PasswordDialog
extends JDialog
implements ActionListener {
    ActionListener onEsc = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PasswordDialog.this.setVisible(false);
        }
    };
    public static final String CMD_OK = "OK";
    public static final String CMD_CANCEL = "CANCEL";
    protected boolean okState = false;
    JLabel prompt = new JLabel();
    JLabel nameLabel = new JLabel();
    JTextField name = new JTextField();
    JLabel passLabel = new JLabel();
    JPasswordField pass = new JPasswordField();
    JButton ok = new JButton();
    JButton cancel = new JButton();

    public void actionPerformed(ActionEvent actionEvent) {
        this.okState = actionEvent.getActionCommand().equals(CMD_OK);
        this.setVisible(false);
    }

    public String getName() {
        return this.name.getText();
    }

    public String getPassword() {
        return new String(this.pass.getPassword());
    }

    public boolean isOkState() {
        return this.okState;
    }

    private void jbInit(Container container, String string) throws Exception {
        MessageFormat messageFormat = new MessageFormat(Strings.get("login.prompt"));
        Object[] objectArray = new Object[]{string};
        this.prompt.setText(messageFormat.format(objectArray));
        this.nameLabel.setText(Strings.get("login.label.name"));
        this.name.setFont(new Font("Dialog", 0, 14));
        this.name.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PasswordDialog.this.pass.requestFocus();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                PasswordDialog.this.ok.setEnabled(PasswordDialog.this.name.getText().length() != 0);
            }
        });
        this.passLabel.setText(Strings.get("login.label.pass"));
        this.pass.setFont(new Font("Dialog", 0, 14));
        this.pass.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PasswordDialog.this.ok.doClick();
                }
            }
        });
        Strings.setButtonText(this.ok, "login.ok");
        this.ok.setEnabled(false);
        this.ok.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PasswordDialog.this.ok.doClick();
                }
            }
        });
        this.ok.setActionCommand(CMD_OK);
        this.ok.addActionListener(this);
        Strings.setButtonText(this.cancel, "login.cancel");
        this.cancel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    PasswordDialog.this.cancel.doClick();
                }
            }
        });
        this.cancel.setActionCommand(CMD_CANCEL);
        this.cancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(14, 14, 8, 14);
        container.add((Component)this.prompt, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 14, 0, 6);
        container.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        container.add((Component)this.passLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 14);
        container.add((Component)this.name, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        container.add((Component)this.pass, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(14, 6, 14, 6);
        container.add((Component)this.ok, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(14, 6, 14, 14);
        container.add((Component)this.cancel, gridBagConstraints);
        this.pack();
        this.setResizable(false);
    }

    public PasswordDialog(JFrame jFrame, String string) {
        super(jFrame, PasswordDialog.makeTitle(string), true);
        try {
            this.jbInit(this.getContentPane(), string);
            this.getRootPane().registerKeyboardAction(this.onEsc, KeyStroke.getKeyStroke(27, 0), 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String makeTitle(String string) {
        MessageFormat messageFormat = new MessageFormat(Strings.get("login.title"));
        Object[] objectArray = new Object[]{string};
        return messageFormat.format(objectArray);
    }
}

