/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.sessions;

import com.eloquence.services.sessions.Session;
import com.eloquence.services.tools.HtmlTool;
import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.ListCellRenderer;

class SessionListCellRenderer
implements ListCellRenderer {
    private JLabel label = new JLabel();
    private JProgressBar progressBar = null;

    public SessionListCellRenderer() {
        Font font = this.label.getFont();
        this.label.setFont(new Font(font.getName(), 0, font.getSize()));
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(2);
        this.progressBar = new JProgressBar();
        font = this.progressBar.getFont();
        this.progressBar.setFont(new Font(font.getName(), 0, font.getSize()));
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximum(20);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Session session = (Session)object;
        if (session.startIndicatorTimeout > 0) {
            if (session.currProgress == 0) {
                this.progressBar.setString(HtmlTool.text(session.getName()));
            } else if (session.currProgress == this.progressBar.getMaximum()) {
                session.currProgress = 0;
            }
            this.progressBar.setValue(++session.currProgress);
            return this.progressBar;
        }
        if (bl) {
            this.label.setBackground(jList.getSelectionBackground());
            this.label.setForeground(jList.getSelectionForeground());
        } else {
            this.label.setBackground(jList.getBackground());
            this.label.setForeground(jList.getForeground());
        }
        this.label.setIcon(session.getIcon());
        Icon icon = this.label.getIcon();
        if (icon != null) {
            int n2 = 40 - icon.getIconWidth();
            if (n2 < 8) {
                n2 = 8;
            }
            this.label.setIconTextGap(n2);
        }
        this.label.setText(session.getName());
        return this.label;
    }
}

