/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.sessions;

import com.eloquence.services.Application.StartUp;
import com.eloquence.services.sessions.Session;
import com.eloquence.services.sessions.SessionListCellRenderer;
import com.eloquence.services.tools.Strings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class SessionView
extends JPanel
implements ActionListener {
    GridBagLayout layoutManager = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JList sessionList = new JList(new DefaultListModel());
    private Timer sessionTimer = null;
    private final int sessionTimerDelay = 50;
    private final int sessionStartTimeout = 600;
    public static boolean cancelSessionTimer = false;

    public void setView() {
        DefaultListModel defaultListModel = (DefaultListModel)this.sessionList.getModel();
        defaultListModel.clear();
        for (Session session : Session.getSessions()) {
            if (!session.isVisible()) continue;
            defaultListModel.addElement(session);
        }
        this.sessionList.setModel(defaultListModel);
    }

    public static void showWarning(String string) {
        cancelSessionTimer = true;
        System.err.println(string);
        JOptionPane.showMessageDialog(null, string, Strings.get("message.warning.title"), 2);
    }

    public static void showError(String string) {
        cancelSessionTimer = true;
        System.err.println(string);
        JOptionPane.showMessageDialog(null, string, Strings.get("message.error.title"), 0);
    }

    public SessionView() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((DefaultListModel)this.sessionList.getModel()).addElement("     ");
    }

    protected void finalize() throws Throwable {
        this.removeAll();
    }

    private void jbInit() throws Exception {
        this.setBorder(new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Strings.get("console.window.applications.title")));
        this.setLayout(this.layoutManager);
        this.sessionList.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                Session session;
                if (mouseEvent.getClickCount() >= 2 && (session = (Session)SessionView.this.sessionList.getSelectedValue()) != null) {
                    Session.start(session, null);
                }
            }
        });
        this.sessionList.setBorder(new EmptyBorder(2, 8, 2, 8));
        this.sessionList.setFont(new Font("Dialog", 0, 14));
        this.sessionList.setMinimumSize(new Dimension(10, 10));
        this.sessionList.setSelectionMode(0);
        this.sessionList.setVisibleRowCount(5);
        this.sessionList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Session session;
                if (keyEvent.getKeyChar() == '\n' && (session = (Session)SessionView.this.sessionList.getSelectedValue()) != null) {
                    Session.start(session, null);
                }
            }
        });
        this.jScrollPane1.setToolTipText("");
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(2, 2, 2, 2), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.sessionList, null);
        this.sessionList.setCellRenderer(new SessionListCellRenderer());
    }

    private void startSessionTimer() {
        cancelSessionTimer = false;
        if (this.sessionTimer == null) {
            this.sessionTimer = new Timer(50, this);
        }
        if (this.sessionTimer.isRunning()) {
            this.sessionTimer.restart();
        } else {
            this.sessionTimer.start();
        }
    }

    public static void startSessionTimer(Session session) {
        SessionView sessionView = StartUp.sessionView;
        if (sessionView != null) {
            session.startIndicatorTimeout = sessionView.sessionStartTimeout;
            session.currProgress = 0;
            sessionView.startSessionTimer();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Session session = null;
        int n = 0;
        int n2 = 0;
        Iterator iterator = Session.getSessions().iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Session session2 = (Session)iterator.next();
            if (!session2.isVisible()) continue;
            if (session2.startIndicatorTimeout > 0) {
                if (--session2.startIndicatorTimeout > 0 && (n == 0 || n > session2.startIndicatorTimeout)) {
                    session = session2;
                    n = session2.startIndicatorTimeout;
                    n2 = n3;
                }
                this.sessionList.repaint(this.sessionList.getCellBounds(n3, n3));
            }
            ++n3;
        }
        if (cancelSessionTimer) {
            cancelSessionTimer = false;
            if (session != null) {
                session.startIndicatorTimeout = 0;
                this.sessionList.repaint(this.sessionList.getCellBounds(n2, n2));
            }
        }
    }
}

