/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import com.eloquence.services.tools.Glob;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class InetTool {
    private static final Pattern IPv6ZeroGroup = Pattern.compile("((^|(?<=:))0:){2,}+");
    private static final String IPv4Basic = "(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
    private static final Pattern IPv4 = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final Pattern IPv6 = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
    private static final Pattern IPv6Compressed = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
    private static final Pattern IPv4MappedIPv6 = Pattern.compile("^::[fF]{4}:(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    public static final int VERIFY_NONE = 0;
    public static final int VERIFY_STRICT = 1;
    public static final int VERIFY_LOOSE = 2;
    private static final String[] Org2ndLvlDomains = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    private static final Pattern SubjectCN;

    public static String getHostAddress(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        if (!(inetAddress instanceof Inet6Address)) {
            return string;
        }
        Matcher matcher = IPv6ZeroGroup.matcher(string);
        int n = -1;
        int n2 = 0;
        while (matcher.find()) {
            int n3 = matcher.end() - matcher.start();
            if (n3 <= n2) continue;
            n = matcher.start();
            n2 = n3;
        }
        if (n == -1) {
            return "[".concat(string).concat("]");
        }
        if (n == 0) {
            return "[::".concat(string.substring(n + n2)).concat("]");
        }
        return "[".concat(string.substring(0, n)).concat(":").concat(string.substring(n + n2)).concat("]");
    }

    public static boolean isIPAddress(String string) {
        return string != null && (InetTool.isIPv4Address(string) || InetTool.isIPv6Address(string));
    }

    public static boolean isIPv4Address(String string) {
        return string != null && IPv4.matcher(string).matches();
    }

    public static boolean isIPv6Address(String string) {
        return string != null && (InetTool.isIPv6StandardAddress(string) || InetTool.isIPv6CompressedAddress(string) || InetTool.isIPv4MappedIPv6Address(string));
    }

    public static boolean isIPv6StandardAddress(String string) {
        return string != null && IPv6.matcher(string).matches();
    }

    public static boolean isIPv6CompressedAddress(String string) {
        if (string != null) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ':') continue;
                ++n;
            }
            if (n <= 7) {
                return IPv6Compressed.matcher(string).matches();
            }
        }
        return false;
    }

    public static boolean isIPv4MappedIPv6Address(String string) {
        return string != null && IPv4MappedIPv6.matcher(string).matches();
    }

    public static String getNormalizedIPAddress(String string) {
        if (InetTool.isIPv6Address(string)) {
            try {
                return InetAddress.getByName(string).getHostAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public static boolean verifyHostName(String string, List list, int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        if (string != null && list != null) {
            String string2 = string.toLowerCase(Locale.US);
            boolean bl = InetTool.isIPAddress(string2);
            if (bl) {
                string2 = InetTool.getNormalizedIPAddress(string2);
            }
            ListIterator listIterator = list.listIterator();
            block6: while (listIterator.hasNext()) {
                int n2;
                String string3;
                try {
                    string3 = ((String)listIterator.next()).toLowerCase(Locale.US);
                }
                catch (Throwable throwable) {
                    continue;
                }
                int n3 = n2 = bl ? -1 : string3.lastIndexOf(42);
                if (n2 >= 0) {
                    if (n2 != string3.indexOf(42)) continue;
                    int n4 = string2.length();
                    int n5 = string3.length();
                    int n6 = 0;
                    int n7 = 3;
                    int n8 = 0;
                    while (true) {
                        String string4;
                        int n9;
                        int n10 = string2.lastIndexOf(46, n4 - 1);
                        int n11 = string3.lastIndexOf(46, n5 - 1);
                        String string5 = string2.substring(n10 + 1, n4);
                        if (string5.length() == 0 || (n9 = (string4 = string3.substring(n11 + 1, n5)).length()) == 0) continue block6;
                        if (++n6 == 1) {
                            n8 = n9;
                        } else if (n6 == 2 && n8 == 2 && Arrays.binarySearch(Org2ndLvlDomains, string4) >= 0) {
                            ++n7;
                        }
                        if (n10 == -1) {
                            if (n11 != -1 || !(n2 > n11 && n2 < n5 ? n6 >= n7 && Glob.match(string4, string5) : string5.equals(string4))) continue block6;
                            return true;
                        }
                        if (n2 > n11 && n2 < n5) {
                            if (n6 < n7) continue block6;
                            if (n9 == 1) {
                                if (n11 != -1) continue block6;
                                if (n == 2) {
                                    return true;
                                }
                            } else if (!Glob.match(string4, string5)) {
                                continue block6;
                            }
                        } else if (!string5.equals(string4)) continue block6;
                        if (n11 == -1) continue block6;
                        n4 = n10;
                        n5 = n11;
                    }
                }
                if (!string2.equals(InetTool.getNormalizedIPAddress(string3))) continue;
                return true;
            }
        }
        return false;
    }

    public static void verifyHostName(String string, SSLSession sSLSession, int n) throws SSLException, CertificateParsingException {
        Object object;
        Object object2;
        if (n == 0) {
            return;
        }
        LinkedList linkedList = new LinkedList();
        if (sSLSession != null && ((Certificate[])(object2 = sSLSession.getPeerCertificates())).length > 0) {
            object = (X509Certificate)object2[0];
            InetTool.getCertSubjectCNs((X509Certificate)object, linkedList);
            InetTool.getCertSubjectAlts(string, (X509Certificate)object, linkedList);
            if (InetTool.verifyHostName(string, linkedList, n)) {
                return;
            }
        }
        object2 = new StringBuilder();
        object = linkedList.listIterator();
        while (object.hasNext()) {
            String string2;
            try {
                string2 = ((String)object.next()).toLowerCase(Locale.US);
            }
            catch (Throwable throwable) {
                continue;
            }
            if (((StringBuilder)object2).length() == 0) {
                ((StringBuilder)object2).append(" (");
            } else {
                ((StringBuilder)object2).append(", ");
            }
            ((StringBuilder)object2).append(string2);
        }
        if (((StringBuilder)object2).length() != 0) {
            ((StringBuilder)object2).append(')');
        }
        throw new SSLException("Host name '" + string + "' does not match SSL certificate" + ((StringBuilder)object2).toString());
    }

    private static void getCertSubjectCNs(X509Certificate x509Certificate, List list) {
        Principal principal = x509Certificate.getSubjectDN();
        if (principal != null) {
            Matcher matcher = SubjectCN.matcher(principal.toString());
            while (matcher.find()) {
                String string;
                if (matcher.groupCount() != 3 || list.contains(string = matcher.group(3))) continue;
                list.add(string);
            }
        }
    }

    private static void getCertSubjectAlts(String string, X509Certificate x509Certificate, List list) throws CertificateParsingException {
        int n = InetTool.isIPAddress(string) ? 7 : 2;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            try {
                for (List<?> list2 : collection) {
                    String string2;
                    if (n != (Integer)list2.get(0) || list.contains(string2 = (String)list2.get(1))) continue;
                    list.add(string2);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        Arrays.sort(Org2ndLvlDomains);
        SubjectCN = Pattern.compile("((^|,)\\s*CN=)([^,]+)", 2);
    }
}

