/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class PropFile {
    private BufferedReader reader = null;
    private String lastEntry = null;
    private String lastValue = null;
    private boolean fileTypeChecked = false;
    private boolean fileTypeRecognized = false;

    public PropFile(InputStream inputStream) throws UnsupportedEncodingException {
        this.close();
        this.reader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
    }

    public void close() {
        this.reader = null;
        this.lastValue = null;
        this.lastEntry = null;
        this.fileTypeRecognized = false;
        this.fileTypeChecked = false;
    }

    public boolean isPropFile() {
        if (!this.fileTypeChecked) {
            this.nextLine();
        }
        return this.fileTypeRecognized;
    }

    public String[] nextEntry() {
        if (this.lastEntry == null && this.nextLine() == null) {
            return null;
        }
        String[] stringArray = this.lastEntry.split("\\.");
        this.lastEntry = null;
        return stringArray;
    }

    public String getValue() {
        return this.lastValue;
    }

    private String nextLine() {
        String string = null;
        try {
            if (!this.fileTypeChecked) {
                this.fileTypeChecked = true;
                this.fileTypeRecognized = false;
            }
            while ((string = this.reader.readLine()) != null) {
                if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
                int n = string.indexOf("=");
                if (n < 0) {
                    this.lastValue = null;
                    this.lastEntry = null;
                    return null;
                }
                this.lastEntry = string.substring(0, n).trim();
                this.lastValue = string.substring(n + 1).trim();
                this.fileTypeRecognized = true;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lastValue = null;
        this.lastEntry = null;
        return null;
    }
}

