/*
 * Decompiled with CFR 0.152.
 */
package com.eloquence.services.tools;

import com.eloquence.services.tools.NativeWin32;
import com.eloquence.services.tools.RawPrinter;

public class RawPrinterWin32
implements RawPrinter {
    private NativeWin32 dll = new NativeWin32();
    private String printerName = null;
    private int errCode = 0;
    private static final int ERR_OK = 0;
    private static final int ERR_NATIVE_FAILURE = 1;
    private static final int ERR_NOT_OPEN = 2;
    private static final int ERR_ALREADY_OPEN = 3;

    public boolean open(String string) {
        if (this.dll.getPrinterHandle() != 0L) {
            this.errCode = 3;
            return false;
        }
        if ((string == null || string.length() == 0) && this.printerName != null && this.printerName.length() > 0) {
            string = this.printerName;
        }
        if (!this.dll.printerOpen(string)) {
            this.errCode = 1;
            return false;
        }
        this.errCode = 0;
        return true;
    }

    public boolean print(byte[] byArray, int n, int n2) {
        if (this.dll.getPrinterHandle() == 0L) {
            this.errCode = 2;
            return false;
        }
        if (!this.dll.printerWrite(byArray, n, n2)) {
            this.errCode = 1;
            return false;
        }
        this.errCode = 0;
        return true;
    }

    public boolean close() {
        if (this.dll.getPrinterHandle() == 0L) {
            this.errCode = 2;
            return false;
        }
        if (!this.dll.printerClose()) {
            this.errCode = 1;
            return false;
        }
        this.errCode = 0;
        return true;
    }

    public String printerName() {
        return this.dll.getPrinterName();
    }

    public void setPrinterName(String string) {
        this.printerName = string;
    }

    public String lastError() {
        switch (this.errCode) {
            case 1: {
                String string = this.dll.getPrinterLastError();
                return string != null ? string : "Memory allocation failed";
            }
            case 2: {
                return "Printer has not been opened";
            }
            case 3: {
                return "Printer is already open";
            }
        }
        return "";
    }

    public String printers() {
        return this.dll.getPrinters();
    }

    protected void finalize() {
        if (this.dll.getPrinterHandle() != 0L) {
            this.dll.printerClose();
        }
    }
}

